/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import committee.nova.mods.avaritia.common.entity.arrow.HeavenSubArrowEntity;
import committee.nova.mods.avaritia.common.item.InfinityArmorItem;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.handler.ItemCaptureHandler;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.util.ClustersUtils;
import committee.nova.mods.avaritia.util.math.RayTracer;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ToolUtils {
    public static final Set<TagKey<Block>> materialsPick = Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_144282_, Tags.Blocks.STONE, Tags.Blocks.STORAGE_BLOCKS, Tags.Blocks.GLASS, Tags.Blocks.ORES, BlockTags.f_215824_, Tags.Blocks.ORE_BEARING_GROUND_DEEPSLATE, Tags.Blocks.COBBLESTONE_DEEPSLATE});
    public static final Set<TagKey<Block>> materialsAxe = Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_13106_, BlockTags.f_201924_, BlockTags.f_13035_});
    public static final Set<TagKey<Block>> materialsShovel = Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_144283_});
    private static final List<String> projectileAntiImmuneEntities = Lists.newArrayList((Object[])new String[]{"minecraft:enderman", "minecraft:wither", "minecraft:ender_dragon", "draconicevolution:guardian_wither"});

    public static boolean canUseTool(BlockState state, Set<TagKey<Block>> keySets) {
        return state.m_204343_().collect(Collectors.toSet()).retainAll(keySets);
    }

    private static void destroy(ServerLevel world, Player player, BlockPos pos, ItemStack heldItem) {
        if (heldItem != null) {
            heldItem.m_41720_().m_6813_(heldItem, (Level)world, world.m_8055_(pos), pos, (LivingEntity)player);
            world.m_46961_(pos, true);
        }
    }

    public static boolean isPlayerWearing(LivingEntity entity, EquipmentSlot slot, Predicate<Item> predicate) {
        ItemStack stack = entity.m_6844_(slot);
        return !stack.m_41619_() && predicate.test(stack.m_41720_());
    }

    public static boolean isInfinite(LivingEntity player) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !(stack = player.m_6844_(slot)).m_41619_() && stack.m_41720_() instanceof InfinityArmorItem) continue;
            return false;
        }
        return true;
    }

    public static void breakRangeBlocks(Player player, ItemStack stack, BlockPos pos, int range, Set<TagKey<Block>> keySets, boolean filterTrash) {
        BlockHitResult traceResult = RayTracer.retrace(player, range);
        Level world = player.m_9236_();
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_()) {
            return;
        }
        if (world.m_5776_()) {
            return;
        }
        boolean doY = traceResult.m_82434_().m_122434_() != Direction.Axis.Y;
        BlockPos minOffset = new BlockPos(-range, doY ? -1 : -range, -range);
        BlockPos maxOffset = new BlockPos(range, doY ? range * 2 - 2 : range, range);
        ToolUtils.breakBlocks((ServerLevel)world, player, stack, pos, minOffset, maxOffset, keySets, filterTrash);
    }

    private static void breakBlocks(ServerLevel world, Player player, ItemStack stack, BlockPos origin, BlockPos min, BlockPos max, Set<TagKey<Block>> validMaterials, boolean filterTrash) {
        ItemCaptureHandler.enableItemCapture(true);
        for (int lx = min.m_123341_(); lx < max.m_123341_(); ++lx) {
            for (int ly = min.m_123342_(); ly < max.m_123342_(); ++ly) {
                for (int lz = min.m_123343_(); lz < max.m_123343_(); ++lz) {
                    BlockPos pos = origin.m_7918_(lx, ly, lz);
                    ToolUtils.removeBlockWithDrops(world, player, pos, stack, validMaterials);
                }
            }
        }
        ItemCaptureHandler.enableItemCapture(false);
        ClustersUtils.spawnClusters((Level)world, player, filterTrash ? ClustersUtils.removeTrash(ItemCaptureHandler.getCapturedDrops()) : ItemCaptureHandler.getCapturedDrops());
    }

    public static void removeBlockWithDrops(ServerLevel world, Player player, BlockPos pos, ItemStack stack, Set<TagKey<Block>> validMaterials) {
        if (!world.m_46749_(pos)) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (world.f_46443_) {
            return;
        }
        if (state.m_60713_(Blocks.f_50034_) && stack.m_150930_((Item)ModItems.infinity_pickaxe.get())) {
            world.m_46597_(pos, Blocks.f_50493_.m_49966_());
        }
        if (!block.canHarvestBlock(state, (BlockGetter)world, pos, player) || !ToolUtils.canUseTool(state, validMaterials)) {
            return;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent((Level)world, pos, state, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            if (!player.m_7500_()) {
                ToolUtils.destroy(world, player, pos, stack);
            } else {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    public static void arrowBarrage(Entity shooter, Level level, List<Entity> piercedAndKilledEntities, AbstractArrow.Pickup pickup, RandomSource randy, BlockPos pos) {
        for (int i = 0; i < 30; ++i) {
            double angle = randy.m_188500_() * 2.0 * Math.PI;
            double dist = randy.m_188583_() * 0.5;
            double x = Math.sin(angle) * dist + (double)pos.m_123341_();
            double z = Math.cos(angle) * dist + (double)pos.m_123343_();
            double y = (double)pos.m_123342_() + 25.0;
            double dangle = randy.m_188500_() * 2.0 * Math.PI;
            double ddist = randy.m_188500_() * 0.35;
            double dx = Math.sin(dangle) * ddist;
            double dz = Math.cos(dangle) * ddist;
            HeavenSubArrowEntity subArrow = HeavenSubArrowEntity.create(level, x, y, z);
            if (shooter != null) {
                subArrow.m_5602_(shooter);
            }
            subArrow.f_36702_ = piercedAndKilledEntities;
            subArrow.m_5997_(dx, -(randy.m_188500_() * 1.85 + 0.15), dz);
            subArrow.m_36762_(true);
            subArrow.m_36781_(((Integer)ModConfig.subArrowDamage.get()).intValue());
            subArrow.f_36705_ = pickup;
            level.m_7967_((Entity)subArrow);
        }
    }

    public static DamageSource getArrowDamageSource(AbstractArrow arrow, Entity owner, Entity target) {
        DamageSource damagesource;
        if (owner == null) {
            damagesource = target.m_269291_().m_269418_(arrow, (Entity)arrow);
        } else {
            damagesource = target.m_269291_().m_269418_(arrow, owner);
            if (owner instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)owner;
                livingEntity.m_21335_(target);
            }
        }
        if (owner != null && projectileAntiImmuneEntities.contains(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_())).toString())) {
            damagesource = ModDamageTypes.causeRandomDamage(owner);
        }
        return damagesource;
    }

    public static void infinityArrowDamage(@NotNull EntityHitResult result, Arrow arrow) {
        Player player;
        Arrow owner;
        Entity entity = result.m_82443_();
        float f = (float)arrow.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * arrow.m_36789_()), (double)0.0, (double)2.147483647E9));
        Object object = owner = arrow.m_19749_() == null ? arrow : arrow.m_19749_();
        if (arrow.m_36796_() > 0) {
            if (arrow.f_36701_ == null) {
                arrow.f_36701_ = new IntOpenHashSet(5);
            }
            if (arrow.f_36702_ == null) {
                arrow.f_36702_ = Lists.newArrayListWithCapacity((int)5);
            }
            if (arrow.f_36701_.size() >= arrow.m_36796_() + 1) {
                arrow.m_146870_();
                return;
            }
            arrow.f_36701_.add(entity.m_19879_());
        }
        if (arrow.m_36792_()) {
            long j = arrow.f_19796_.m_188503_(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        DamageSource damagesource = ToolUtils.getArrowDamageSource((AbstractArrow)arrow, (Entity)owner, entity);
        boolean isEnderman = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (arrow.m_6060_() && !isEnderman) {
            entity.m_20254_(5);
        }
        if (entity instanceof Player && (player = (Player)entity).m_6117_() && player.m_21211_().m_41720_() instanceof ShieldItem) {
            player.m_36335_().m_41524_(player.m_21211_().m_41720_(), 100);
            arrow.m_9236_().m_7605_((Entity)player, (byte)30);
            player.m_5810_();
        }
        if (entity.m_6469_(damagesource, (float)i)) {
            if (entity instanceof LivingEntity) {
                ServerPlayer serverPlayer;
                Vec3 vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!arrow.m_9236_().f_46443_ && arrow.m_36796_() <= 0) {
                    livingentity.m_21317_(livingentity.m_21234_() + 1);
                }
                if (arrow.f_36699_ > 0 && (vector3d = arrow.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)arrow.f_36699_ * 0.6)).m_82556_() > 0.0) {
                    livingentity.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
                }
                if (!arrow.m_9236_().f_46443_ && owner instanceof LivingEntity) {
                    LivingEntity livingOwner = (LivingEntity)owner;
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)livingOwner);
                    EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)livingentity);
                }
                arrow.m_7761_(livingentity);
                if (livingentity != owner && livingentity instanceof Player && owner instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)owner;
                    if (!arrow.m_20067_()) {
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                    }
                }
                if (!entity.m_6084_() && arrow.f_36702_ != null) {
                    arrow.f_36702_.add(livingentity);
                }
                if (!arrow.m_9236_().f_46443_ && owner instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)owner;
                    if (arrow.f_36702_ != null && arrow.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverPlayer, (Collection)arrow.f_36702_);
                    } else if (!entity.m_6084_() && arrow.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverPlayer, List.of(entity));
                    }
                }
            }
            arrow.m_5496_(arrow.m_36784_(), 1.0f, 1.2f / (arrow.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (arrow.m_36796_() <= 0) {
                arrow.m_146870_();
            }
        } else {
            entity.m_7311_(k);
            arrow.m_20256_(arrow.m_20184_().m_82490_(0.0));
            arrow.m_146922_(arrow.m_146908_() + 180.0f);
            arrow.m_146884_(entity.m_20182_());
            arrow.f_19859_ += 180.0f;
            if (!arrow.m_9236_().f_46443_ && arrow.m_20184_().m_82556_() < 1.0E-7) {
                if (arrow.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    arrow.m_5552_(arrow.m_7941_(), 0.1f);
                }
                arrow.m_146870_();
            }
        }
    }

    public static void sweepAttack(Level level, LivingEntity livingEntity, LivingEntity victim) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (LivingEntity livingentity : level.m_45976_(LivingEntity.class, player.m_21120_(InteractionHand.MAIN_HAND).getSweepHitBox(player, (Entity)victim))) {
                double entityReachSq = Mth.m_144952_((double)player.getEntityReach());
                if (player.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(player.m_20280_((Entity)livingentity) < entityReachSq)) continue;
                livingentity.m_147240_((double)0.6f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                victim.m_21153_(0.0f);
                victim.m_6667_(player.m_269291_().m_268998_(ModDamageTypes.INFINITY, (Entity)player, (Entity)victim));
            }
            level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_12317_, livingEntity.m_5720_(), 1.0f, 1.0f);
            double d0 = -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, player.m_20185_() + d0, player.m_20227_(0.5), player.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            }
        }
    }

    public static void aoeAttack(Player player, float range, float damage, boolean hurtAnimal, boolean lightOn) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        AABB aabb = player.m_20191_().m_82406_((double)range);
        List toAttack = player.m_9236_().m_45933_((Entity)player, aabb);
        DamageSource src = player.m_269291_().m_268998_(ModDamageTypes.INFINITY, (Entity)player, (Entity)player);
        toAttack.stream().filter(entity -> entity instanceof Mob).forEach(arg_0 -> ToolUtils.lambda$aoeAttack$1(hurtAnimal, src, damage, player, lightOn, arg_0));
    }

    public static boolean canHarvest(BlockPos pos, Level world) {
        if (!ToolUtils.isLogOrLeaves(world, pos)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_61147_().stream().anyMatch(p -> p.equals((Object)RotatedPillarBlock.f_55923_))) {
            return ((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)).equals((Object)Direction.Axis.Y);
        }
        return true;
    }

    public static void destroyTree(Player player, ServerLevel world, BlockPos pos, ItemStack heldItem) {
        List<BlockPos> connectedLogs = ToolUtils.getConnectedLogs((Level)world, pos);
        ItemCaptureHandler.enableItemCapture(true);
        for (BlockPos logPos : connectedLogs) {
            ToolUtils.destroy(world, player, logPos, heldItem);
        }
        ItemCaptureHandler.enableItemCapture(false);
        ClustersUtils.spawnClusters((Level)world, player, ItemCaptureHandler.getCapturedDrops());
    }

    private static List<BlockPos> getConnectedLogs(Level world, BlockPos pos) {
        BlockPosList positions = new BlockPosList();
        ToolUtils.collectLogs(world, pos, positions);
        return positions;
    }

    private static void collectLogs(Level world, BlockPos pos, BlockPosList positions) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos p = pos.m_7918_(x, y, z);
                    if (!ToolUtils.isLogOrLeaves(world, p) || !positions.add(p)) continue;
                    posList.add(p);
                }
            }
        }
        for (BlockPos p : posList) {
            ToolUtils.collectLogs(world, p, positions);
        }
    }

    private static boolean isLogOrLeaves(Level world, BlockPos pos) {
        BlockState b = world.m_8055_(pos);
        return b.m_204336_(BlockTags.f_13106_) || b.m_204336_(BlockTags.f_13035_);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$aoeAttack$1(boolean hurtAnimal, DamageSource src, float damage, Player player, boolean lightOn, Entity entity) {
        block8: {
            if (!(entity instanceof Mob)) break block8;
            mob = (Mob)entity;
            if (!(mob instanceof Animal)) ** GOTO lbl-1000
            animal = (Animal)mob;
            if (hurtAnimal) {
                animal.m_6469_(src, damage);
            } else if (mob instanceof EnderDragon) {
                dragon = (EnderDragon)mob;
                dragon.m_31120_(dragon.f_31080_, src, Infinityf);
            } else if (mob instanceof WitherBoss) {
                wither = (WitherBoss)mob;
                wither.m_31510_(0);
                wither.m_6469_(src, damage);
            } else if (!(mob instanceof Animal)) {
                mob.m_6469_(src, damage);
            }
        }
        lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(player.m_9236_());
        if (!(!lightOn || lightningbolt == null || entity instanceof Animal && hurtAnimal)) {
            lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)entity.m_20183_()));
            lightningbolt.m_20879_(player instanceof ServerPlayer != false ? (serverPlayer = (ServerPlayer)player) : null);
            player.m_9236_().m_7967_((Entity)lightningbolt);
        }
    }

    private static class BlockPosList
    extends ArrayList<BlockPos> {
        private BlockPosList() {
        }

        @Override
        public boolean add(BlockPos pos) {
            if (!this.contains(pos)) {
                return super.add(pos);
            }
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.stream().anyMatch(pos1 -> pos1.equals(o));
        }
    }
}

